var req;
var card = -1;
var numCards = 54;
var debugEnabled = false;
var refreshInterval;
var siteURL = "http://www.maya.com/web/what/what_cards.mtml";

// debug printing function
function debug(text) {
    if (debugEnabled) {
        alert(text);
    }
}

// create a widget-instance-particular version of a key name
function createkey(key)
{
	return widget.identifier + "-" + key;
}

// brings the user to the site associated with the widget
function gotoSite() {
	if (window.widget) {
		widget.openURL(siteURL);
	} else {
		window.location.href = siteURL;
	}
}

// show the card face
function showPrefs()
{
    debug("showing prefs");
	var front = document.getElementById("front");
	var back = document.getElementById("back");
	
	if (window.widget)
		widget.prepareForTransition("ToBack");		// freezes the widget so that you can change it without the user noticing
	
	front.style.display="none";		// hide the front
	back.style.display="block";		// show the back
	
	// hide the "glow"
	document.getElementById("flipl").style.zIndex = -10;
	document.getElementById("flipr").style.zIndex = -10;
	
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);		// and flip the widget over	
		
}

// switch to the card back
function hidePrefs()
{
	var front = document.getElementById("front");
	var back = document.getElementById("back");
	
	if (window.widget)
		widget.prepareForTransition("ToFront");		// freezes the widget and prepares it for the flip back to the front
	
	setCard(randomCardNumber()); // swap card out during flip
	back.style.display="none";			// hide the back
	front.style.display="block";		// show the front
	document.getElementById("flipl").style.zIndex = 10;
	document.getElementById("flipr").style.zIndex = 10;

	if (window.widget)
		setTimeout ('widget.performTransition();', 0);		// and flip the widget back to the front
}

// set the current card to the one specified by index cardNum
function setCard(cardNum) {
    debug("setting card to number " + cardNum);
    card = cardNum % numCards;
    cardImg = document.getElementById("cardface");
    cardImg.src = getCardImageName(card);
    
    // remember this setting for next session
    if (window.widget) {
        widget.setPreferenceForKey(card, createkey("card"));
    }
}

// converts from card index to name of associated image
function getCardImageName(cardNum) {
    numstr = "" + cardNum;
    if (numstr.length == 1) {
        numstr = "0" + numstr;
    }
    return "Images/card" + numstr + ".png";
}

// get a random card number (built-in version yielded predictable sequence!)
function randomCardNumber() {
    debug("generating random number");
    return rand(numCards);
}

// get all the card images into RAM, so we don't flip over into nothingness
function preloadImages() {
    images = new Array();
    for (i = 0; i < numCards; i++) {
        images[i] = new Image();
        images[i].src = getCardImageName(i);
    }
}

// called when we're first loaded
function init() {
    preloadImages();
    
    debug('init');
    
    // see if there's state to restore from last time
    if (window.widget) {
        card = widget.preferenceForKey(createkey("card"));
    }
    
    debug('card=' + card);
    
    // pick a new random card, if necessary
    if (!card || card < 0) {
        setCard(randomCardNumber());
    } else {
        setCard(card);
        showPrefs();
    }
    
    // set the show/hide functions; mostly no-op in this widget	
	if (window.widget) {
	    widget.onshow = function OnShow() {
	        debug("widget shown");
	    }
	    widget.onremove = function OnRemove() {
	        debug("widget removed");
	        widget.setPreferenceForKey(null, createkey("card"));
	    }
	    widget.onhide = function OnHide() {
	        debug("widget hidden");
	    }
	}
}
